#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   agentName = 'TwampAgent'

   # In future it will look at te/config dynamic min-min
   twampLightConfig = context.lookup( 'monitor/twamp/twampLight/config' )
   twampLightStatus = context.lookup( 'monitor/twamp/twampLight/status' )
   runnability = [ { 'entity': twampLightConfig, 'qualAttr': 'senderProfile' },
                   { 'entity': twampLightConfig, 'qualAttr': 'reflectorProfile' },
                   { 'entity': twampLightStatus, 'qualAttr': 'active' },
                 ]

   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/TwampAgent',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability': runnability,
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
