#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( 'hardware/powercontroller/config/ucd90120' )

   systemAgentName = "Ucd9012-system"
   systemAgentCfg = { "name": systemAgentName,
                      "exe": "/usr/bin/Ucd9012",
                      "argv": [ '--system', '--dontDieOnDisconnect' ],
                      "heartbeatPeriod": 30,
                      "runnability": [
                         { "entity": config, "qualAttr": "realUcd9012Controller" },
                         { "entity": config, "qualAttr": "realUcd9032Controller" },
                         { "entity": config, "qualAttr": "realPsocController" },
                      ],
                    }
   role = { 'rpr' : context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }
   context.agentConfigIs( role, systemAgentCfg )

   cellAgentName = "Ucd9012"
   perCellPath = "hardware/cell/%cellId/powercontroller/config/ucd90120"
   cellAgentCfg = { "name": cellAgentName,
                    "exe": "/usr/bin/Ucd9012",
                    "argv": [],
                    "heartbeatPeriod": 30,
                    "runnability": [
                       { "qualPath": perCellPath + ".realUcd9012Controller/%*" },
                       { "qualPath": perCellPath + ".realUcd9032Controller/%*" },
                       { "qualPath": perCellPath + ".realPsocController/%*" },
                     ],
                  }
   roleName = context.allCellsRoleName
   context.agentConfigIs( roleName, cellAgentCfg )
