#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   vlConfig = context.lookup( 'routing/vrfleak/config' )

   # VrfLeak run logic is: ( haveConfig AND multiAgent ) OR dirty

   runnability = [ ( { 'qualPath' :
                       'cell/%cellId/routing/defaultVrfProtocolLaunch/IpRib' },
                     { 'entity' : vlConfig, 'qualAttr' : 'vrf' }, ),
                   { 'qualPath' : 'cell/%cellId/routing/vrfleak/dirty/dirty' } ]

   agentCfg = { 'name': 'VrfLeak',
                'exe': '/usr/bin/VrfLeak',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability' : runnability }

   roleName = context.allSupervisorsRoleName
   context.agentConfigIs( roleName, agentCfg )
