#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
# pkgdeps: import LauncherContext

def Plugin( context ):
   vxlanConfigDir = context.lookup( 'vxlan/config' )
   vxlanStatusDir = context.lookup( 'vxlan/status' )
   fhrpVxRunnability = context.lookup( 'routing/fhrp/input/runnability/vxlan' )

   # Vxlan runs unconditionally on the active supervisor.
   agentName = "Vxlan"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/Vxlan",
                "argv": [],
                "heartbeatPeriod": 120,
                "runnability": [ { "entity": vxlanConfigDir,
                                   "qualAttr": "vxlanConfig" },
                                 { "entity": vxlanStatusDir,
                                   "qualAttr": "vxlanStatus" },
                                 # This is only used for cleanup. We should
                                 # set the vxlanEnabled flag for Fhrp to false
                                 # before the Launcher kills the agent
                                 { "entity": fhrpVxRunnability,
                                   "qualAttr": "vxlanEnabled" } ]
                }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
