#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   vxlancontrollerConfig = context.lookup( "vxlancontroller/config" )
   controllerdbStatus = context.lookup( "controller/status" )
   defaultClusterStatus = context.lookup(
      "controller/cluster/statusDir.status/default" )
   vxlancontrollerStatus = context.lookup( "vxlancontroller/status" )

   agentName = "VxlanController"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/VxlanController",
                "argv": [],
                "heartbeatPeriod": 120,

                # Runnability logic is
                # ( vcsConfigEnabled && controllerdbStatusEnabled && leadership ) ||
                # ( vcsStatusEnabled )
                #
                # In other words,
                # "VCS is enabled AND
                #  Controllerdb is ready AND
                #  this CVX server is standalone or is elected as leader of the
                #  cluster by ControllerOob"
                # OR
                # "VCS didn't complete cleanup"
                "runnability": [ ( { "entity" : vxlancontrollerConfig,
                                     "qualAttr" : "enable" },
                                   { "entity" : controllerdbStatus,
                                     "qualAttr" : "enabled" },
                                   { "entity" : defaultClusterStatus,
                                     "qualAttr" : "isStandaloneOrLeader" } ),
                                 { "entity" : vxlancontrollerStatus,
                                   "qualAttr" : "enable" } ]
                }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
