#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   vxlanConfigDir = context.lookup( 'vxlan/config' )

   # Configure the VxlanSwFwd agent to run on the active supervisor when
   # the vxlan interface is configured.
   agentName = "VxlanSwFwd"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/VxlanSwFwd",
                "argv": [],
                "heartbeatPeriod": 120,
                "oomScoreAdj": -350, # see AID3426
                "runnability": [ { "entity": vxlanConfigDir,
                                   "qualAttr": "vxlanConfig" } ]
                }
   roleName = { 'rpr': context.activeSupervisorRoleName,
                'sso': context.allSupervisorsRoleName }
   context.agentConfigIs( roleName, agentCfg )
