#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext
import WanTEUtilsAgent

def Plugin( context ):
   avtCliConfig = context.lookup( 'avt/input/cli' )
   runnability = { 'entity': avtCliConfig,
                   'qualAttr': 'avtConfigured' }
   agentName = WanTEUtilsAgent.name
   exePath = f"/usr/bin/{agentName}"
   agentCfg = { "name": agentName,
                "exe": exePath,
                "argv": [],
                "heartbeatPeriod": 30,
                "coredumpTimeout": 200,
                "runnability": runnability,
              }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
