# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from LauncherContext import LauncherContext
import Swag
from typing import Type

def Plugin( context: Type[ LauncherContext ] ) -> None:
   if not Swag.isMember():
      return

   agentCfg = { "name": "WorkerSchanAccelProxy",
                "exe": "/usr/bin/WorkerSchanAccelProxy",
                "argv": [ "--smid=%(smid)s" ],
                "heartbeatPeriod": 30,
                "oomScoreAdj": -300,
                "runnability": [],
                "swagRunnabilityFilter": context.swagWorkerOnly,
   }

   context.agentConfigIs( context.allSupervisorsRoleName, agentCfg )
