# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   dmfCliConfig = context.lookup( 'dmf/cli/config' )
   ztnStatus = context.lookup( 'ztn/status' )
   runnability = [ { 'entity': dmfCliConfig, 'qualAttr': 'enabled' },
                   { 'entity': ztnStatus, 'qualAttr': 'enabled' } ]
   agentCfg = {
      "name": "Ztn",
      "exe": "/usr/bin/Ztn",
      "argv": [],
      "heartbeatPeriod": 300,
      "runnability": runnability
   }
   context.agentConfigIs( context.activeSupervisorRoleName, agentCfg )
