# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from codecs import decode

from TypeFuture import TacLazyType

ChassisIdentifier = TacLazyType( "Lldp::ChassisIdentifier" )
PortIdentifier = TacLazyType( "Lldp::PortIdentifier" )
PortStatus = TacLazyType( "Lldp::PortStatus" )
Msap = TacLazyType( "Lldp::RemoteSystem::Msap" )
RemoteSystem = TacLazyType( "Lldp::RemoteSystem" )

BoundedBytes32Tlv = TacLazyType( "Lldp::BoundedBytes32Tlv" )
BoundedBytes255Tlv = TacLazyType( "Lldp::BoundedBytes255Tlv" )
BoundedBytes255 = TacLazyType( "Lldp::BoundedBytes255" )
SystemCapabilitiesTlv = TacLazyType( "Lldp::SystemCapabilitiesTlv" )
ManagementAddressKey = TacLazyType( "Lldp::ManagementAddress::Key" )
ManagementAddress = TacLazyType( "Lldp::ManagementAddress" )
ManAddrPriority = TacLazyType( "Lldp::ManAddrPriority" )
UnknownTlv = TacLazyType( "Lldp::UnknownTlv" )
UnknownOrgDefTlvKey = TacLazyType( "Lldp::UnknownOrgDefTlv::Key" )
UnknownOrgDefTlv = TacLazyType( "Lldp::UnknownOrgDefTlv" )

VlanName = TacLazyType( "Lldp::VlanName" )
PortAndProtocolVlan = TacLazyType( "Lldp::PortAndProtocolVlan" )
ProtocolIdentityInfo = TacLazyType( "Lldp::ProtocolIdentityInfo" )

MacPhyConfigStatusInfo = TacLazyType( "Lldp::MacPhyConfigStatusInfo" )
LinkAggregationInfo = TacLazyType( "Lldp::LinkAggregationInfo" )
MaximumFrameSizeInfo = TacLazyType( "Lldp::MaximumFrameSizeInfo" )

ExternalTlvPortConfigKey = TacLazyType( "Lldp::ExternalTlvPortConfig::Key" )
MgmtAddrTxOption = TacLazyType( "Lldp::MgmtAddrTxOption" )

SystemCapabilitiesMap = TacLazyType( "Lldp::SystemCapabilitiesMap" )
PortConfig = TacLazyType( "Lldp::PortConfig" )
EnabledTlvs = TacLazyType( "Lldp::PortConfig::EnabledTlvs" )
Dot1EnabledTlvs = TacLazyType( "Lldp::PortConfig::Dot1EnabledTlvs" )
Dot3EnabledTlvs = TacLazyType( "Lldp::PortConfig::Dot3EnabledTlvs" )
TiaEnabledTlvs = TacLazyType( "Lldp::PortConfig::TiaEnabledTlvs" )
LinkAggStatusMap = TacLazyType( "Lldp::LinkAggStatusMap" )

LocalPortPoeInfo = TacLazyType( "Lldp::LocalPortPoeInfo" )
MedCapabilitiesInfo = TacLazyType( "Lldp::MedCapabilitiesInfo" )
Capability = TacLazyType( "Lldp::MedCapabilitiesInfo::Capability" )
MedDeviceType = TacLazyType( "Lldp::MedCapabilitiesInfo::MedDeviceType" )
Watts = TacLazyType( "Units::Watts" )

PowerViaMdiInfo = TacLazyType( "Lldp::PowerViaMdiInfo" )
PowerViaMdiInfo_IeeeStandard = TacLazyType( "Lldp::PowerViaMdiInfo::IeeeStandard" )
PowerViaMdiInfo_At = TacLazyType( "Lldp::PowerViaMdiInfo::At" )
PowerViaMdiInfo_Bt = TacLazyType( "Lldp::PowerViaMdiInfo::Bt" )
PowerViaMdiInfo_PdPoweredStatus = TacLazyType(
     "Lldp::PowerViaMdiInfo::Bt::PdPoweredStatus" )
PowerViaMdiInfo_PowerClassExt = TacLazyType(
     "Lldp::PowerViaMdiInfo::Bt::PowerClassExt" )

NetworkPolicyConfig = TacLazyType( 'Lldp::NetworkPolicyConfig' )
NetworkPolicyTlv = TacLazyType( 'Lldp::NetworkPolicyTlv' )

LocationIdTlv = TacLazyType( 'Lldp::LocationId' )
CoordinateBasedLCI = TacLazyType( 'Lldp::LocationId::CoordinateBasedLCI' )
EcsElin = TacLazyType( 'Lldp::LocationId::EcsElin' )
CivicAddressLCI = TacLazyType( "Lldp::LocationId::CivicAddressLCI" )
CivicAddressLCI_Element = TacLazyType(
      "Lldp::LocationId::CivicAddressLCI::CaElement" )

EscapedString = TacLazyType( "Lldp::EscapedString" )

def escapedString( origString ):
   """Return a string with all non-ASCII and ASCII control codes escaped"""
   return EscapedString.fromBytes( origString )

def unescapedString( s ):
   return decode( s, "unicode_escape" )
