#!/usr/bin/env arista-python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=raise-missing-from
# pylint: disable=consider-using-f-string
# pylint: disable=used-before-assignment

import Tac

def stopRepeatLog( name ):
   del Tac.singleton( 'Ark::LogRepeaterManager' ).logSm[ name ]
   
def startRepeatLog( name, stringId, *args ):
   argList = list( args )
   maxArgs = 10
   idStr = stringId # pylint: disable=unused-variable
   try:
      facility, mnemonic = stringId.split( "_", 1 )
   except:
      raise ValueError( "Bad id '%s' for log message -- id must contain a '_' to " \
         "separate facility and mnemonic" % id)
   id = '%s-%s' %( facility, mnemonic ) # pylint: disable=redefined-builtin
   al = len( argList )
   if al > maxArgs:
      assert False, 'Too many args to log(): %d (max allowed is %d)' % \
          ( al, maxArgs )

   logMgr = Tac.singleton( 'Tac::LogManager' )
   msg = logMgr.logMsg[ id ]
   
   # The args may have come in as none-strings -- convert them into
   # strings now.
   argStrs = [ str( a ) for a in argList ] + [ "0", ] * ( maxArgs - len( argList ) )
   
   logString = Tac.Value( 'Tac::LogString' )
   logString.stringCount = al
   for i in range( len( argStrs ) ): # pylint: disable=consider-using-enumerate
      logString.str[ i ] = argStrs[ i ]
         
   Tac.singleton( 'Ark::LogRepeaterManager' ).logSm.newMember(
                                 Tac.singleton('Tac::ActivityManagerConfig').clock,
                                 msg, logString, name )
