#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=no-name-in-module
# pylint: disable=wrong-import-position

#
# Initialize Marco module that loads libEventMarco.so library and imports MarcoPython
# module. It also exports functions implemented in MarcoPython.
#

import ctypes
ctypes.CDLL( 'libEventMarco.so', mode=ctypes.RTLD_GLOBAL )

# import definitions from MarcoPython
from MarcoPython import _waitFor
from MarcoPython import fastForward
from MarcoPython import setFastForward
from MarcoPython import time
from MarcoPython import endOfTime
from MarcoPython import _processTitle
from MarcoPython import _processStartTime
from MarcoPython import TimeoutException
from MarcoPython import setRandomSeed
from MarcoPython import rand
from MarcoPython import rand64
from MarcoPython import throwOnAssertFailIs
from MarcoPython import enableNetZero
from MarcoPython import is32Bit

# wrap waitFor() to avoid having to overload the function arguments using boost
def waitFor( cond, description='', timeout=600, warnAfter=1.0, delay=0.05 ):
   return _waitFor( cond, description, timeout, delay, warnAfter )

# wrap readProcTitle() to avoid having to use boost::optional
def processTitle( pid=0 ):
   return _processTitle( pid )

def processStartTime( pid=0 ):
   return _processStartTime( pid )
