#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=c-extension-no-member
# pylint: disable=protected-access

import sys
import os

import MarcoPython
# pylint: disable-next=no-name-in-module,unused-import
from MarcoPython import setupMarcoDebug
# pylint: disable-next=no-name-in-module,unused-import
from MarcoPython import clearMarcoDebug
# pylint: disable-next=no-name-in-module,unused-import
from MarcoPython import setTraceFormat
# pylint: disable-next=no-name-in-module,unused-import
from MarcoPython import clearTraceFormat

# This Handle class holds the debug handle passed from the C++ implementation.
# The usage of this handle object is similar to that of in C++. Example:
# dh = Handle( "HandleName" )   # Creating an instance of handle with the given name.
# dh.DEBUG0( "Debug messages" ) # Using the handle to print level 0 debug message.
class Handle:
   def __init__( self, handleName=None ):
      if handleName is None:
         # Only get the filename, without the path and extension
         handleName = self._getFrameInfo()[ 0 ].split( '.' )[ 0 ]
      self.debugHandle_ = MarcoPython._getDebugHandle( handleName )

   # Find out the file name, line num, func name of the caller of DEBUGN() by getting
   # the right frame from the call stacks. Since _getFrameInfo() will be called by
   # DEBUGN(), the frameDepth is set to 2.
   def _getFrameInfo( self ):
      frameDepth = 2
      f = sys._getframe( frameDepth )
      line = f.f_lineno
      fileName = os.path.basename( f.f_code.co_filename )
      funcName = f.f_code.co_name
      return ( fileName, line, funcName )

   def  DEBUG0( self, msg ):
      ( fileName, line, funcName ) = self._getFrameInfo()
      MarcoPython._debugN_h( self.debugHandle_, msg, 0, fileName, funcName, line )
   def  DEBUG1( self, msg ):
      ( fileName, line, funcName ) = self._getFrameInfo()
      MarcoPython._debugN_h( self.debugHandle_, msg, 1, fileName, funcName, line )
   def  DEBUG2( self, msg ):
      ( fileName, line, funcName ) = self._getFrameInfo()
      MarcoPython._debugN_h( self.debugHandle_, msg, 2, fileName, funcName, line )
   def  DEBUG3( self, msg ):
      ( fileName, line, funcName ) = self._getFrameInfo()
      MarcoPython._debugN_h( self.debugHandle_, msg, 3, fileName, funcName, line )
   def  DEBUG4( self, msg ):
      ( fileName, line, funcName ) = self._getFrameInfo()
      MarcoPython._debugN_h( self.debugHandle_, msg, 4, fileName, funcName, line )
   def  DEBUG5( self, msg ):
      ( fileName, line, funcName ) = self._getFrameInfo()
      MarcoPython._debugN_h( self.debugHandle_, msg, 5, fileName, funcName, line )
   def  DEBUG6( self, msg ):
      ( fileName, line, funcName ) = self._getFrameInfo()
      MarcoPython._debugN_h( self.debugHandle_, msg, 6, fileName, funcName, line )
   def  DEBUG7( self, msg ):
      ( fileName, line, funcName ) = self._getFrameInfo()
      MarcoPython._debugN_h( self.debugHandle_, msg, 7, fileName, funcName, line )
   def  DEBUG8( self, msg ):
      ( fileName, line, funcName ) = self._getFrameInfo()
      MarcoPython._debugN_h( self.debugHandle_, msg, 8, fileName, funcName, line )
   def  DEBUG9( self, msg ):
      ( fileName, line, funcName ) = self._getFrameInfo()
      MarcoPython._debugN_h( self.debugHandle_, msg, 9, fileName, funcName, line )
