#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# ErrorCodes for fast lookup and API reference

errorCodes = {
   "105": "Deleting Sender <sender post> that was not configured",
   "112": "Unavailable sender",
   "113": "Invalid flow-action = <postedAction>. Valid action (To Configure "
   "Receivers = addReceivers/ delReceivers, To configure senders = addSenders/ "
   "delSenders/ modBw) ",
   "114": "FailedReceivers in post",
   "117": "No ValidReceivers to configure in this post",
   "118": "Unexpected Error <traceback>",
   "120": "Sender already added. stored bandwidth is different for sourceIP = "
   "<sourceIP> destinationIP = <destinationIP>. Actual bandwidth = "
   "<actualBandwidth>. Use mod-bw action to modify bandwidth",
   "121": "Invalid POST data type. POST data has to be a list",
   "122": "inIntfID is not the same as stored sender ID = <deviceId>-<port>",
   "123": "Invalid bandwidth. Set Positive Integer value.",
   "124": "Invalid bandwidth Type <bwType>",
   "125": "<address> Not in Unicast Address range",
   "126": "<address> Not in Multicast Address range",
   "127": "No Source Address present",
   "129": "No Multicast Address present",
   "131": "Missing Key = <key>",
   "132": "Invalid inIntfID. No MACID present",
   "133": "Invalid inIntfID. No Port present",
   "137": "Invalid Device Id = <deviceId>",
   "138": "Invalid Reservation percentage. Valid values should be between 0.0 to "
   "1.0",
   "139": "Invalid reservation percentage. Post a valid percentage example:1.0",
   "156": "Reservation percentage can only be set for Ethernet "
   "ports/interface-name == 'all' for all Ethernet ports",
   "159": "ERROR: Sender and Receiver port for s:g = <sourceIp:destinationIp> "
   "cannot be same sender = <deviceId:port> receiver = <deviceId:port>",
   "161": "Device = <deviceId>:<portId> does not have enough bandwidth",
   "164": "Receiver = <deviceId:portId> is not a direct connection or "
   "cannot be reached via 1 hop spine. Check if sender and receivers shared "
   "spine is visible in network-links",
   "166": "Sender = <srcDeviceId> does not have any connections to receiver = "
   "<rcvDeviceId>",
   "182": "Missing or invalid type inIntfID",
   "183": "Unexpected inIntfID format. Expected <senderMacId>-<port>",
   "184": "Unsupported Port. Use only Ethernet/Vlan port format",
   "185": "FailedSenders in post",
   "186": "Invalid OUI. Enter comma/colon/hyphen separated OUI",
   "187": "Invalid endpoint requested",
   "198": "No path diversity",
   "199": "Interface does not exist on device - missing IntfId",
   "210": "The only connections between sender and receiver contain "
          "devices set to maintenance mode",
   "211": "Failure to reroute maintenance-impacted receiver. "
          "Flow remains programmed on device(s) in maintenance",
   "230": "Invalid request data type. The request data type has to be a JSON object",
   "232": "Label exceeds a character length of 253",
   "231": "Invalid interface-name = <interface-name> for deviceId = <deviceId>",
   "233": "Invalid interface range for deviceId = <deviceId>",
   "235": "Partially configured POST request due to some invalid data in POST"
   " request",
   "236": "No flows failing for the given filtering criteria",
   "237": "Invalid dscp: <dscp>, valid range is { 0, 63 }",
   "238": "Invalid tc: <tc>, valid range is { 0, 7 }",
   "239": "Invalid applyPolicy: <applyPolicy>, valid values are True, False",
   "240": "Invalid weight: <weight>, valid integer range is { 1, 2048 }",
   "241": "Invalid mode: <mode>, valid values are disabled, consistent",
   "243": "Invalid inIntfID in boundary interface. No <Device> with  "
   "<MACID> present",
   "244": "Invalid inIntfID in boundary interface. No <Device> with "
   "<Port> present",
   "245": "Invalid add action. Boundary interface=<BoundaryIntfName> already"
   " exist, use action=modify to modify",
   "246": "Invalid del/modify action. Boundary interface=<BoundaryIntfName>"
   " [<interface>] has active sender/receivers",
   "247": "Invalid paired flow request: Flow <flow1> already paired with"
   " flow <flow2>",
   "248": "Invalid boundary-interface action = <postedAction>. Valid actions are-"
   "define,del",
   "249": "Invalid boundary interface name=<name> or name contains more than 64"
   " characters",
   "250": "Physical interfaces list in boundary interface=<boundaryIntf> is empty or"
   " has more than 1000 physical interfaces",
   "251": "Failed boundary interfaces in POST",
   "252": "Boundary interface=<bIntf> is not configured",
   "253": "Invalid paired flow request: Flow <flow1> and <flow2> already"
   " programmed.",
   "254": "Invalid trackingID",
   "255": "Invalid transactionID",
   "256": "Invalid del/modify action as there are active senders/receivers in"
   " boundary interface",
   "257": "Invalid request interface Id=<intfId> can not be used as it is part of"
   " boundary interface=<bIntf>",
}

# Use for publishing these codes to the MCS TOI
# Copy the printed output to Google Sheets and paste into Google Docs
if __name__ == '__main__':
   for k in sorted( errorCodes ):
      print( f"{k},{errorCodes[ k ]}" )
