#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from __future__ import absolute_import, division, print_function
import MlagMountHelper
from MlagShared import configCheckDir as CCD
import Tracing
from Toggles.MlagToggleLib import toggleMlagSubintfConfigSanityEnabled
t2 = Tracing.trace2

# subdirDeprecated collection is being deprecated from EOS.
# To be compatible with past/future releases, follow these
# recommendations:
# Do not introduce any new calls to newSubdirDeprecated
# i.e call newEntity to create an entity
# rather than a subdir.
# If looking up a subdir, first look in entityPtr collection
# if the key is not found, look in subdirDeprecated collection
# See AID/7616 for more details

def Plugin( ctx ):
   # Create local directories to be shared with peer.
   # subdirDeprecated collection is being deprecated from EOS.
   # do not introduce new calls to newSubdirDeprecated,
   # use newEntity to create an entity instead.
   # see message on top of this file regarding subdirDeprecated
   # lookup/creation.
   bridgingDir = ctx.configCheckP2pDir.newSubdirDeprecated( 'bridging' )
   p2pBridgingConfig = bridgingDir.newEntity( "MlagP2p::ConfigCheck::GenericConfig",
                                               "config" )
   smContainer = ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::SmContainer',
                                                 'BridgingConfigCheckSm')
   # Mount from sysdb.
   mg = ctx.entityManager.mountGroup()
   bridgingInputConfig = mg.mount( 'bridging/input/config/cli',
                              'Bridging::Input::CliConfig', 'r')
   # Mount mlag/config, Mlag::Config and its dependent paths
   mlagConfig = MlagMountHelper.mountMlagConfig( mg )
   mlagStatus = MlagMountHelper.mountMlagStatus( mg )
   configCheckDesc = \
       ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::ConfigCheckDesc',
                                       'Bridging')

   vlanConfigEntT = configCheckDesc.newNestedConfigCheckDesc('vlanConfig')
   vlanConfigEntT.attrName['adminState'] = 'admin-state vlan'
   vlanConfigEntT.attrName[ 'macLearning' ] = 'mac-learning vlan'
   vlanConfigEntT.collectionName['trunkGroup'] = 'trunk-group vlan'

   switchIntfConfigEntT = \
       configCheckDesc.newNestedConfigCheckDesc('switchIntfConfig')
   switchIntfConfigEntT.mlagInterfacesOnly = True
   switchIntfConfigEntT.absenceImpliesDefaultVal = True
   switchIntfConfigEntT.attrName['switchportMode'] = 'switchport-mode'
   switchIntfConfigEntT.attrName[ 'macLearningEnabled' ] = 'switchport mac learning'
   switchIntfConfigEntT.attrName['accessVlan'] = 'access-vlan'
   switchIntfConfigEntT.attrName['trunkNativeVlan'] = 'trunk-native-vlan'
   switchIntfConfigEntT.attrName['trunkAllowedVlans'] = 'trunk-allowed vlan'
   switchIntfConfigEntT.attrName['vlanTpid'] = 'vlan-Tpid'
   switchIntfConfigEntT.attrName[ 'phoneVlan' ] = 'phone-vlan'
   switchIntfConfigEntT.attrName[ 'phoneTrunk' ] = 'phone-trunk'
   switchIntfConfigEntT.attrName[ 'phoneTrunkTagMode' ] = 'phone-trunk-tag-mode'
   switchIntfConfigEntT.attrName[ 'accessVlanEgressEnabled' ] \
           = 'access-vlan-egress-enabled'
   switchIntfConfigEntT.attrName[ 'nativeVlanEgressEnabled' ] \
           = 'native-vlan-egress-enabled'

   # provide default values for the interface ( since absenceImpliesDefaultVal )
   switchIntfConfigEntT.defaultVal['switchportMode'] = '\'access\''
   switchIntfConfigEntT.defaultVal[ 'macLearningEnabled' ] = 'True'
   switchIntfConfigEntT.defaultVal['accessVlan'] = '1'
   switchIntfConfigEntT.defaultVal['trunkNativeVlan'] = '1'
   switchIntfConfigEntT.defaultVal['trunkAllowedVlans'] = '\'1-4094\''
   # pylint: disable-next=consider-using-f-string
   switchIntfConfigEntT.defaultVal['vlanTpid'] = '{}'.format( 0x8100 )
   switchIntfConfigEntT.defaultVal[ 'phoneVlan' ] = '0'
   switchIntfConfigEntT.defaultVal[ 'phoneTrunk' ] = 'False'
   switchIntfConfigEntT.defaultVal[ 'phoneTrunkTagMode' ] = '\'notSet\''
   switchIntfConfigEntT.defaultVal[ 'accessVlanEgressEnabled' ] = 'False'
   switchIntfConfigEntT.defaultVal[ 'nativeVlanEgressEnabled' ] = 'False'

   switchIntfConfigEntT.collectionName['trunkGroup'] = 'trunk-group'

   # allocating configCheckDesc for bridging attributes and nested entities to 
   # monitor for configured subinterfaces
   if toggleMlagSubintfConfigSanityEnabled():
      if ctx.configCheckP2pDir.get( 'subintf' ):
         subIntfDir = ctx.configCheckP2pDir[ 'subintf' ]
      else:
         subIntfDir = ctx.configCheckP2pDir.newSubdirDeprecated( 'subintf' )
      p2pSubIntfConfig = subIntfDir.newEntity( "MlagP2p::ConfigCheck::GenericConfig",
                                               "subIntfVlanConfig" )
      subIntfSmContainer = ctx.configCheckDir.newEntity( \
                        'Mlag::ConfigCheck::SmContainer','SubIntfVlanConfigCheckSm' )
      subintfConfigCheckDesc = \
               ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::ConfigCheckDesc',
                                             'SubIntfVlan' )
      subintfSwitchIntfConfigEntT = \
               subintfConfigCheckDesc.newNestedConfigCheckDesc( 'switchIntfConfig' )
      subintfSwitchIntfConfigEntT.mlagSubinterfacesOnly = True
      subintfSwitchIntfConfigEntT.attrName[ 'l2SubIntfVlan' ] = 'subintf-vlan'

   def peerRoot():
      return ctx.mountStatus.peerRoot

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'

   def handleActive( mlagState, failover ):
      if activeSupervisor() and peerRoot():
         try:
            configCheckDir = CCD( peerRoot() )
            bridgingDir = None
            # subdirDeprecated collection is being deprecated from EOS.
            # to be compatible with past/future releases 
            # first look up in default collection ( entityPtr )
            # see message on top of this file regarding subdirDeprecated
            # lookup/creation.
            if configCheckDir.get( 'bridging' ):
               bridgingDir = configCheckDir['bridging']
            else:
               # lookup in subdirDeprecated collection
               bridgingDir = configCheckDir.subdirDeprecated['bridging']
            peerBridgingConfig = bridgingDir.entity[ 'config' ]

            if toggleMlagSubintfConfigSanityEnabled():
               cfgSubintfDir = None
               if configCheckDir.get( 'subintf' ):
                  cfgSubintfDir = configCheckDir[ 'subintf' ]
               else:
                  # lookup in subdirDeprecated collection
                  cfgSubintfDir = configCheckDir.subdirDeprecated[ 'subintf' ]
               peerSubIntfConfig = cfgSubintfDir.entity[ 'subIntfVlanConfig' ]
         except KeyError:
            # This is an ISSU case. We will not have a configChecker for Bridging.
            return
         if smContainer.configCheckSm:
            if mlagState == 'primary':
               if failover:
                  bridgingConfigCheckCleanup()
         else:
            configCheck = ctx.configCheckPlugin( "bridging" )
            smContainer.configCheckSm = ( configCheck, 'Bridging',
                                          bridgingInputConfig, p2pBridgingConfig,
                                          peerBridgingConfig, configCheckDesc,
                                          mlagConfig, mlagStatus )
               
         if toggleMlagSubintfConfigSanityEnabled():
            if subIntfSmContainer.configCheckSm:
               if mlagState == 'primary'and failover:
                  subintfConfigCheckCleanup()
            else:
               subintfConfigCheck = ctx.configCheckPlugin( "subIntfVlan" )
               # set feature name for this plugin
               subintfConfigCheck.pluginName = "subinterface"
               subIntfSmContainer.configCheckSm = ( subintfConfigCheck, 
                                                    'SubIntfVlan', 
                                                    bridgingInputConfig, 
                                                    p2pSubIntfConfig,
                                                    peerSubIntfConfig, 
                                                    subintfConfigCheckDesc, 
                                                    mlagConfig, mlagStatus )

      elif not peerRoot():
         t2( "Deleting configcheckSm because peerRoot is none" )
         bridgingConfigCheckCleanup()
         if toggleMlagSubintfConfigSanityEnabled():
            subintfConfigCheckCleanup()

   def bridgingConfigCheckCleanup():
      smContainer.configCheckSm = None
      if activeSupervisor():
         ctx.configCheckPluginDel( "bridging" )

   def subintfConfigCheckCleanup():
      subIntfSmContainer.configCheckSm = None
      if activeSupervisor():
         ctx.configCheckPluginDel( "subIntfVlan" )

   def handleInactive():
      t2( "handle mlag state Inactive in BridgingConfigCheck" )
      bridgingConfigCheckCleanup()
      if toggleMlagSubintfConfigSanityEnabled():
         subintfConfigCheckCleanup()

   def finishMounts():
      t2( "Mounts complete" )
      def handleMlagStateForBridgingConfigCheck( mlagState, failover ):
         t2( "mlagState:", mlagState )

         if mlagState in ("primary", "secondary"):
            handleActive( mlagState, failover )
         else:
            handleInactive()
      ctx.callbackIs( handleMlagStateForBridgingConfigCheck )

   mg.close( finishMounts )

