# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
import MlagMountHelper
from MlagShared import configCheckDir

t2 = Tracing.trace2

def Plugin( ctx ):
   # sysdb mounts
   mg = ctx.entityManager.mountGroup()
   ptpConfig = mg.mount( "ptp/config", "Ptp::Config", "r" )
   mlagConfig = MlagMountHelper.mountMlagConfig( mg )
   mlagStatus = MlagMountHelper.mountMlagStatus( mg )

   # peer
   ptpDir = ctx.configCheckP2pDir.newEntity( "Tac::Dir", 'ptp' )
   p2pPtpConfig = ptpDir.newEntity( "MlagP2p::ConfigCheck::GenericConfig",
                                       "ptpConfig" )
   ptpSmContainer = ctx.configCheckDir.newEntity(
                                    "Mlag::ConfigCheck::SmContainer",
                                    "PtpConfigCheckSm" )
   ptpConfigCheckDesc = ctx.configCheckDir.newEntity(
                                    "Mlag::ConfigCheck::ConfigCheckDesc",
                                    "Ptp" )
   ptpConfigCheckDesc.attrName[ 'ptpMode' ] = 'ptp-mode'
   ptpConfigCheckDesc.attrName[ 'unicastNegotiation' ] = 'unicast-negotiation'

   ptpIntfConfigEntT = ptpConfigCheckDesc.newNestedConfigCheckDesc( 'intfConfig' )
   ptpIntfConfigEntT.mlagInterfacesOnly = True
   ptpIntfConfigEntT.attrName[ 'enabled' ] = 'ptp'
   ptpIntfConfigEntT.attrName[ 'mpassEnabled' ] = 'mpass'
   ptpIntfConfigEntT.attrName[ 'delayMechanism' ] = 'delay-mechanism'
   ptpIntfConfigEntT.attrName[ 'transportMode' ] = 'transport'
   ptpIntfConfigEntT.attrName[ 'role' ] = 'role'
   ptpIntfConfigEntT.collectionName[ 'vlanIds' ] = 'vlan'

   def peerRoot():
      return ctx.mountStatus.peerRoot

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'

   def handleActive( mlagState, failover ):
      t2( "Ptp mlag config check handleActive" )
      if activeSupervisor() and peerRoot():
         try:
            peerRootConfigCheck = configCheckDir( peerRoot() )
            peerPtpConfig = peerRootConfigCheck[
                  'ptp' ].entity[ 'ptpConfig' ]
         except KeyError:
            return
         if ptpSmContainer.configCheckSm:
            if mlagState == 'primary':
               if failover:
                  ptpConfigCheckCleanup()
         else:
            ptpConfigCheck = ctx.configCheckPlugin( 'ptp' )
            ptpSmContainer.configCheckSm = ( ptpConfigCheck, 'Ptp', ptpConfig,
                  p2pPtpConfig, peerPtpConfig, ptpConfigCheckDesc, mlagConfig,
                  mlagStatus )
      elif not peerRoot():
         ptpConfigCheckCleanup()

   def ptpConfigCheckCleanup():
      ptpSmContainer.configCheckSm = None
      if activeSupervisor():
         ctx.configCheckPluginDel( 'ptp' )

   def handleInactive():
      t2( "Ptp mlag config check handleInactive" )
      ptpConfigCheckCleanup()

   def finishMounts():
      t2( "Ptp mlag config check mounts complete" )
      def handleMlagStateForPtpConfigCheck( mlagState, failover ):
         if mlagState in ( "primary", "secondary" ):
            handleActive( mlagState, failover )
         else:
            handleInactive()
      ctx.callbackIs( handleMlagStateForPtpConfigCheck )

   mg.close( finishMounts )
