#!/usr/bin/env python3
# # Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# # Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import MlagMountHelper
from MlagShared import configCheckDir as CCD
import Tracing
from Toggles.MlagToggleLib import toggleMlagSubintfConfigSanityEnabled
t2 = Tracing.trace2

def Plugin( ctx ):
   if not toggleMlagSubintfConfigSanityEnabled():
      return
   # create local directories to be shared with peer
   if ctx.configCheckP2pDir.get( 'subintf' ):
      subIntfDir = ctx.configCheckP2pDir[ 'subintf' ]
   else:
      subIntfDir = ctx.configCheckP2pDir.newSubdirDeprecated( 'subintf' )
   p2pSubIntfConfig = subIntfDir.newEntity( "MlagP2p::ConfigCheck::GenericConfig", 
                                            "subIntfEncapConfig" )
   smContainer = ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::SmContainer',
                                                      'SubIntfEncapConfigCheckSm' )
   # Mount from sysdb.
   mg = ctx.entityManager.mountGroup()
   subIntfConfig = mg.mount( "interface/config/subintf", 
                             "Interface::SubIntfConfigDir", "r" )
   
   # Mount mlag/config, Mlag::Config and its dependent paths
   mlagConfig = MlagMountHelper.mountMlagConfig( mg )
   mlagStatus = MlagMountHelper.mountMlagStatus( mg )
   
   configCheckDesc = \
       ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::ConfigCheckDesc', 
                                     'SubIntfEncap' )
   subIntfConfigEntT = configCheckDesc.newNestedConfigCheckDesc( 'intfConfig' )
   subIntfConfigEntT.mlagSubinterfacesOnly = True
   subIntfConfigEntT.attrName[ 'dot1qEncap' ] = \
                                             'dot1q-encapsulation outer-inner vlan'
   subIntfConfigEntT.attrName[ 'flexEncap' ] = 'flex-encap'

   def peerRoot():
      return ctx.mountStatus.peerRoot

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'

   def handleActive( mlagState, failover ):
      if activeSupervisor() and peerRoot():
         try:
            configCheckDir = CCD( peerRoot() )
            subIntfConfigDir = None
            if configCheckDir.get( 'subintf' ):
               subIntfConfigDir = configCheckDir[ 'subintf' ]
            else:
               # lookup in subdirDeprecated collection
               subIntfConfigDir = configCheckDir.subdirDeprecated[ 'subintf' ]
            peerSubIntfConfig = subIntfConfigDir.entity[ 'subIntfEncapConfig' ]
         except KeyError:
            # This is an ISSU case. We will not have a configChecker for Mlag.
            return
         if smContainer.configCheckSm:
            if mlagState == 'primary':
               if failover:
                  t2( "Deleting configchecksm" )
                  subIntfConfigCheckCleanup()
         else:
            configCheck = ctx.configCheckPlugin( "subIntfEncap" )
            # set feature name for this plugin
            configCheck.pluginName = "subinterface"
            smContainer.configCheckSm = ( configCheck, 'SubIntfEncap', 
                                          subIntfConfig, p2pSubIntfConfig, 
                                          peerSubIntfConfig, configCheckDesc, 
                                          mlagConfig, mlagStatus )
      elif not peerRoot():
         t2( "Deleting configcheckSm because peerRoot is none" )
         subIntfConfigCheckCleanup()
 
   def subIntfConfigCheckCleanup():
      smContainer.configCheckSm = None
      if activeSupervisor():
         ctx.configCheckPluginDel( "subIntfEncap" )

   def handleInactive():
      t2( "handle mlag state Inactive in SubIntfConfigCheck" )
      subIntfConfigCheckCleanup()

   def finishMounts():
      t2( "Mounts complete" )
      def handleMlagStateForSubIntfConfigCheck( mlagState, failover ):
         t2( "mlagState:", mlagState )

         if mlagState in ("primary", "secondary"):
            handleActive( mlagState, failover )
         else:
            handleInactive()
      ctx.callbackIs( handleMlagStateForSubIntfConfigCheck )

   mg.close( finishMounts )