#!/usr/bin/env python3
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Tracing

t2 = Tracing.trace2


protocol = 'Vrrp'

def Plugin( ctx ):
   # Create MlagVrrp in agent root dir
   mlagVrrpDir = ctx.agent.parent.newEntity( "Tac::Dir", 'mlagVrrp' )
   smContainer = mlagVrrpDir.newEntity( 'MlagVrrp::SmContainer',
                                        'stateMachine' )
   mGroup = ctx.entityManager.mountGroup()
   mlagConfigDir = mGroup.mount( 'mlag/virtualMac/config',
                                 'Mlag::VirtualMacConfigDir', 'w' )
   vrrpMacStatus = mGroup.mount( 'routing/fhrp/vrMacStatus',
                                 'Routing::Fhrp::VirtualRouterMacStatus', 'r' )

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'

   def handleActive( mlagState, failover ):
      if smContainer.vrrpVirtualMacSm is None:
         vrrpConfig = mlagConfigDir.virtualMacConfig.get( protocol )
         if vrrpConfig is None:
            vrrpConfig = mlagConfigDir.virtualMacConfig.newMember( protocol )

         t2( "Creating Vrrp Virtual Router Mac Reactor" )
         smContainer.vrrpVirtualMacSm = ( vrrpMacStatus, vrrpConfig )

   def handleInactive():
      smContainer.vrrpVirtualMacSm = None

   def finishMounts():
      t2( "Mounts complete" )
      def handleMlagStateForVrrp( mlagState, failover ):
         if not activeSupervisor():
            return

         if mlagState in ( 'primary', 'secondary' ):
            handleActive( mlagState, failover )
         else:
            handleInactive()
      ctx.callbackIs( handleMlagStateForVrrp )

   mGroup.close( finishMounts )
