# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from Ark import ReversibleDict
from TunnelLib import getTunnelTypeEnumVal
from TunnelTypeLib import tunnelTypeStrDict
import Tac

TunnelId = Tac.Type( "Tunnel::TunnelTable::TunnelId" )

showTunnelFibIgnoredTunnelTypes = {
   'staticInterfaceTunnel',
 }

# only do things where the transport type is mpls
# Convert tunnel type strings to CLI tokens
# i.e. 'Static IPv6' to static-ipv6, 'IS IS SR IPv4' to sr-ipv4
def getTunnelTypeTokens():
   tokens = {}
   xlate = {}
   for t, v in tunnelTypeStrDict.items():
      if t in showTunnelFibIgnoredTunnelTypes:
         continue
      if TunnelId.tunnelTransportFromType( getTunnelTypeEnumVal( t ) ) != \
         'mplsTunnel':
         continue

      key = v.lower().replace( " ", "-" ).replace( "is-is-", "" )
      xlate[ key ] = t
      # pylint: disable-next=consider-using-f-string
      tokens[ key ] = 'Match %s tunnel type' % v

   return tokens, xlate

( tunnelTypes, tunnelTypeXlate ) = getTunnelTypeTokens()

tunnelTypeRevXlate = ReversibleDict( tunnelTypeXlate ).reverse()
