#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Arnet
import Tac

# pkgdeps: library MvpnLib
# pkgdeps: library MvpnLibSysdbTypes

namespace = "Routing::Multicast::"

def tacTristatePmsiTunnelType():
   return Tac.Type( namespace + "TristatePmsiTunnelType" )

def tacMvpnSource( source ):
   if isinstance( source, str ):
      source = Arnet.IpGenAddr( source )

   return Tac.Value( namespace + "MvpnSource", source )

def tacMvpnSourceFlags( rptPrune=None, sourceTreeJoin=None, discoveredSg=None ):
   sourceFlags = Tac.Value( namespace + "MvpnSource::SourceFlags" )
   if rptPrune is not None:
      sourceFlags.rptPrune = rptPrune
   if sourceTreeJoin is not None:
      sourceFlags.sourceTreeJoin = sourceTreeJoin
   if discoveredSg is not None:
      sourceFlags.discoveredSg = discoveredSg
   return sourceFlags

def tacMvpnRouteFlagsToSourceFlags( routeFlags ):
   sourceFlags = tacMvpnSourceFlags()
   sourceFlags.rptPrune = routeFlags.rptPrune
   sourceFlags.sourceTreeJoin = routeFlags.sourceTreeJoin
   sourceFlags.discoveredSg = routeFlags.discoveredSg
   return sourceFlags

def tacMvpnRouteKey( source=None, group=None, sharedTreeJoin=False ):

   if source is None and group is None:
      return Tac.Value( namespace + "MvpnRouteKey" )

   assert source is not None and group is not None

   if isinstance( source, str ):
      source = Arnet.IpGenAddr( source )
   if isinstance( group, str ):
      group = Arnet.IpGenAddr( group )

   return Tac.Value( namespace + "MvpnRouteKey", source, group, sharedTreeJoin )

def tacMvpnVrfRouteKey( vrfId=None, source=None, group=None, sharedTreeJoin=False ):
   if vrfId is None and source is None and group is None:
      return Tac.Value( namespace + 'MvpnVrfRouteKey' )

   mvpnRouteKey = tacMvpnRouteKey( source, group, sharedTreeJoin )
   assert vrfId is not None
   return Tac.Value( namespace + 'MvpnVrfRouteKey', vrfId, mvpnRouteKey )

def tacMvpnRouteIntfKey( source=None, group=None, intfId=None ):

   if source is None and group is None and intfId is None:
      return Tac.Value( namespace + "MvpnRouteIntfKey" )

   assert source is not None and group is not None and intfId is not None

   if isinstance( source, str ):
      source = Arnet.IpGenAddr( source )
   if isinstance( group, str ):
      group = Arnet.IpGenAddr( group )

   return Tac.Value( namespace + "MvpnRouteIntfKey", source, group, intfId )

def tacMvpnVrfRouteIntfKey( vrfId=None, source=None, group=None, intfId=None ):
   if vrfId is None and source is None and group is None and intfId is None:
      return Tac.Value( namespace + 'MvpnVrfRouteIntfKey' )

   mvpnRouteIntfKey = tacMvpnRouteIntfKey( source, group, intfId )
   assert vrfId is not None
   return Tac.Value( namespace + 'MvpnVrfRouteIntfKey', vrfId, mvpnRouteIntfKey )

def tacMvpnRoute( rk=None, source=None, group=None, sharedTreeJoin=False ):
   if rk is None:
      rk = tacMvpnRouteKey( source, group, sharedTreeJoin )
   return Tac.Value( namespace + "MvpnRoute", rk )

def tacMvpnRouteFlags( value=0 ):
   return Tac.Value( namespace + "MvpnRoute::RouteFlags", value )

def tacMvpnRouteStatus( name="test" ):
   return Tac.newInstance( namespace + "MvpnRouteStatus", name )

def tacMvpnIntfStatus( name="test" ):
   return Tac.newInstance( namespace + "MvpnIntfStatus", name )

def tacMvpnVrfIntfId( vrfId ):
   return Tac.newInstance( namespace + "MvpnVrfIntfId", vrfId )

def tacMvpnEncapTunnel( rk=None, source=None, group=None, encapTunnel=None ):

   if rk is None:
      if isinstance( source, str ):
         source = Arnet.IpGenAddr( source )
      sharedTreeJoin = source.isAddrZero
      rk = tacMvpnRouteKey( source, group, sharedTreeJoin )

   tunnel = Tac.Value( namespace + "MvpnEncapTunnel", rk )
   if encapTunnel is not None:
      tunnel.encapTunnel = encapTunnel

   return tunnel

def tacMvpnEncapIntfTunnel( rk=None, source=None, group=None, intfId=None,
                            encapIntfTunnel=None ):

   if rk is None:
      if isinstance( source, str ):
         source = Arnet.IpGenAddr( source )
      if isinstance( group, str ):
         group = Arnet.IpGenAddr( group )
      rk = tacMvpnRouteIntfKey( source, group, intfId )

   tunnel = Tac.Value( namespace + "MvpnEncapIntfTunnel", rk )
   if encapIntfTunnel is not None:
      tunnel.encapTunnel = encapIntfTunnel

   return tunnel

def tacMvpnTunnelEncapStatus( name="test" ):
   return Tac.newInstance( namespace + "MvpnTunnelEncapStatus", name )

def tacMvpnVrf( vrfId ):
   return Tac.newInstance( namespace + "MvpnVrf", vrfId )

def tacMvpnVrfStatus( name="test" ):
   return Tac.newInstance( namespace + "MvpnVrfStatus", name )

def tacMvpnTunnelDecapConfig( name="test" ):
   return Tac.newInstance( namespace + "MvpnTunnelDecapConfig", name )

def tacMvpnTunnelDecap( multicastTreeId, pmsiIntfId ):
   return Tac.Value( namespace + "MvpnTunnelDecap", multicastTreeId, pmsiIntfId )

def tacMvpnTunnelDecapStatus( name="test" ):
   return Tac.newInstance( namespace + "MvpnTunnelDecapStatus", name )

def tacMvpnRsvpLeafStatus( name="test" ):
   return Tac.newInstance( namespace + "MvpnRsvpLeafStatus", name )

def tacMvpnRsvpSessionIdLeafSet( sessionId ):
   return Tac.newInstance( namespace + "MvpnRsvpSessionIdLeafSet", sessionId )

def tacMvpnRsvpSessionId( p2mpId, tunnelId, extTunnelId ):
   return Tac.newInstance( namespace + "MvpnRsvpSessionId", p2mpId, tunnelId,
                           extTunnelId )

def tacRsvpMvpnShared( name="test" ):
   return Tac.newInstance( "Rsvp::RsvpMvpnShared", name )

def tacVrfIdToNameStatus( name="test" ):
   return Tac.newInstance( "Vrf::VrfIdMap::Status", name )
