# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#----------------------------------------------------------------
#----------------------------------------------------------------
#----------------------------------------------------------------
# Provide time functions from librt.  This bypasses Atime preload library.
# From http://stackoverflow.com/questions/1205722/
#  how-do-i-get-monotonic-time-durations-in-python
import ctypes, os
CLOCK_MONOTONIC = 1 # see <linux/time.h>

class timespec(ctypes.Structure):
   _fields_ = [
      ('tv_sec', ctypes.c_long),
      ('tv_nsec', ctypes.c_long)
      ]
   
librt = ctypes.CDLL('librt.so.1', use_errno=True)
clock_gettime = librt.clock_gettime
clock_gettime.argtypes = [ctypes.c_int, ctypes.POINTER(timespec)]

# Speed up monotonic_time() by doing the one-time check that CLOCK_MONOTONIC is valid
if clock_gettime(CLOCK_MONOTONIC, ctypes.pointer(timespec())) != 0:
   errno_ = ctypes.get_errno()
   raise OSError(errno_, os.strerror(errno_))

def monotonic_time():
   t = timespec()
   clock_gettime(CLOCK_MONOTONIC, ctypes.pointer(t))
   return t.tv_sec + t.tv_nsec * 1e-9
