# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import Tac

NexthopGroupType = Tac.Type( 'Routing::NexthopGroup::NexthopGroupType' )
ipTunnelNexthopGroupTypes = frozenset( [ NexthopGroupType.ipInIp,
                                         NexthopGroupType.gre,
                                         NexthopGroupType.dzgre,
                                         NexthopGroupType.mplsOverGre,
                                         NexthopGroupType.mplsOverUdp,
                                         NexthopGroupType.ipv4OverUdp,
                                         NexthopGroupType.ipv6OverUdp,
                                         NexthopGroupType.vxlan ] )

nexthopGroupTypes = { NexthopGroupType.ipInIp: 'ip-in-ip',
                      NexthopGroupType.gre: NexthopGroupType.gre,
                      NexthopGroupType.dzgre: NexthopGroupType.dzgre,
                      NexthopGroupType.ip: NexthopGroupType.ip,
                      NexthopGroupType.mpls: NexthopGroupType.mpls,
                      NexthopGroupType.mplsOverGre: 'mpls-over-gre',
                      NexthopGroupType.mplsOverUdp: 'mpls-over-udp',
                      NexthopGroupType.ipv4OverUdp: 'ipv4-over-udp',
                      NexthopGroupType.ipv6OverUdp: 'ipv6-over-udp',
                      NexthopGroupType.vxlan: 'vxlan' }
nexthopGroupTacTypes = frozenset( nexthopGroupTypes )
nexthopGroupTokenTypes = list( nexthopGroupTypes.values() )
nexthopGroupTokenToTacType = { ngToken: ngType for ngType, ngToken in
                               nexthopGroupTypes.items() }

NhgSizeConstants = Tac.Type( 'Routing::NexthopGroup::NexthopGroupSizeConstants' )
EntryCounterType = Tac.Type( 'Routing::NexthopGroup::EntryCounterType' )
GreKeyType = Tac.Type( 'Arnet::GreKeyType' )

# CLI token used to config GRE key
greKeyIngressIntf = 'ingress-interface'
