# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

class NumAllocator:
   '''
   Python wrapper around Ark::NumAllocator to make it easily accessible via Python.
   '''
   def __init__( self, naMin, naMax ):
      r = Tac.Value( 'Ark::Range', naMin, naMax )
      self.config = Tac.newInstance( 'Ark::NumAllocatorConfig', r )
      self.status = Tac.newInstance( 'Ark::NumAllocatorStatus' )
      self.na = Tac.newInstance( 'Ark::NumAllocator',
                                 self.config,
                                 self.status,
                                 Tac.activityManager.clock )

   def getNumber( self ):
      return self.na.getNumber()

   def getExactNumber( self, number ):
      return self.na.getExactNumber( number )

   def releaseNumber( self, number ):
      return self.na.releaseNumber( number )

   def freeNumberInHoldDownPool( self, number ):
      return self.na.freeNumberInHoldDownPool( number )

   def releaseNumberWithExpiry( self, number, expiryDelay ):
      return self.na.releaseNumberWithExpiry( number, expiryDelay )

   def isReserved( self, number ):
      return self.na.isReserved( number )

   def isHoldDown( self, number ):
      return self.na.isHoldDown( number )

   def isFree( self, number ):
      return self.na.isFree( number )

   def getBlocklet( self, size ):
      return self.na.getBlocklet( size )

   def getExactBlocklet( self, blocklet ):
      return self.na.getExactBlocklet( blocklet )

   def releaseBlocklet( self, blocklet ):
      return self.na.releaseBlocklet( blocklet )

   def releaseBlockletWithExpiry( self, blocklet, expiryDelay ):
      return self.na.releaseBlockletWithExpiry( blocklet, expiryDelay )

   def isBlockletReserved( self, blocklet ):
      return self.na.isBlockletReserved( blocklet )

   def isBlockletHoldDown( self, blocklet ):
      return self.na.isBlockletHoldDown( blocklet )

   def isBlockletFree( self, blocklet ):
      return self.na.isBlockletFree( blocklet )

   def reservedCount( self ):
      return self.na.reservedCount()

   def holdDownCount( self ):
      return self.na.holdDownCount()

   def freeCount( self ):
      return self.na.freeCount()
