# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import re

from SfFruHelper import SfFruHelper

class Octeon10FruHelper( SfFruHelper ):
   def sortDevNames( self, devNames ):
      # Sort by PCI address, but the management port comes last so move it to
      # the head of the list
      devNames = self.sortDevNamesByPci( devNames )
      return [ devNames[ -1 ] ] + devNames[ :-1 ]

   def isDeviceUserForceIgnored( self, devName ):
      # Permit ignore by MAC address regex. This is temporary workaround to
      # manually exclude non working interfaces by MAC address in veos-config
      # as interface can show up out of order and get a different name accross
      # boot.
      mac = self.getMac( devName )
      for d in self._forceIgnoredIntfRegxList:
         if re.match( d, mac ):
            return True
      return super().isDeviceUserForceIgnored( devName )

   def getSerialNumber( self ):
      with open( '/sys/firmware/devicetree/base/serial-number' ) as f:
         return f.read().rstrip( '\x00' )

   def getDevType( self, driver ):
      return "cn10k"
