# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def enabled( entity, negate=False ):
   return { "entity": entity, "qualAttr": "enabled", "negate": negate }

def launchRequest( entity, negate=False ):
   return { "qualPath": f"{entity}/%*", "negate": negate }

def openConfigRunnability( context ):
   openconfigEntity = context.lookup( "mgmt/gnmi/config" )
   restconfEntity = context.lookup( "mgmt/restconf/config" )
   netconfEntity = context.lookup( "mgmt/netconf/config" )
   netconfStatusEntity = context.lookup( "mgmt/netconf/status" )
   openConfigLaunchRequestEntity = context.lookup( "mgmt/gnmi/launchRequest" )
   agentCommonRunnability = [
         enabled( openconfigEntity ),
         enabled( restconfEntity ),
         enabled( netconfEntity ),
         enabled( netconfStatusEntity ),
         launchRequest( openConfigLaunchRequestEntity ),
      ]
   return agentCommonRunnability
