# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Different dir for servers in different VRFs, i.e. /tmp/twamp-server-<vrf>/
fileDirPrefix = '/tmp/twamp-server-'
pidFile = 'twamp-server.pid'
infoFile = 'twamp-server.info'
configFile = 'twamp-server.conf'

# Min and max TCP/UDP ports
minPort = 1
maxPort = ( 1 << 16 ) - 1

# Default is for server to respond to TCP connection sent to any
# its local IP addresses. (i.e. socket will be bound to INADDR_ANY)
defaultLocalAddress = "0"

# Default TCP port on which server is listening set to 50099
# Different from RFC 5357's default (762) to avoid:
#   1. having to run the TWAMP server as root
#   2. being blocked by default control plane ACL
defaultListenPort = 50099

# The range of UDP ports on the client that should be used for tests.
# These defaults are allowed by the default control plane ACL.
defaultMinTestPort = 51000
defaultMaxTestPort = 51100

# TWAMP ping command.  Options like destination address, port appended.
pingCommand = "/usr/bin/twping"

# Max number of control sessions concurrently supported by server (0 means unlimited)
maxControlSessions = 64
defaultMaxControlSessions = 0

# Additional server default options
defaultUser = 'admin'
defaultGroup = 'eosadmin'
defaultAuthMode = 'AEO'

# CLI keywords
serverKeyword = 'twserver'
clientKeyword = 'twping'
