#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import Tac

def getPersistentLogPath():
   prlConsts = Tac.Value( 'Stage::PersistentRestartLogConstants' )

   path = os.path.join( 
      os.getenv( prlConsts.simulationPersistentFsEnv,
                 prlConsts.primaryPersistentFs ),
      prlConsts.persistentRestartPath )

   if not os.path.exists( path ):
      path = os.path.join( prlConsts.secondaryPersistentFs,
                           prlConsts.persistentRestartPath )
      # pylint: disable-next=consider-using-f-string
      assert os.path.exists( path ), "%s doesn't exist %s" % path
   return path

def getPersistentLogs():
   '''
   Returns a dict of all saved logs in the persistent FS that will be logged on
   restart
   '''
   # first check simulation directory (in case of btest), fall back to primary
   # directory
   path = getPersistentLogPath()

   ret = {}
   for f in os.listdir( path ):
      with open( os.path.join( path, f ) ) as readfile:
         ret[ f ] = readfile.read()

   return ret

def persistentRestartLog( agent, message ):
   filePath = os.path.join( getPersistentLogPath(), agent )
   with open( filePath, 'a' ) as f:
      f.write( message + '\n' )

      
