#!/usr/bin/env python3
# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""
This module contains utilities that are useful for processing FDL components
for PHYs.
"""

# XXX_LWR: This could probably go into Arbus
import MdioClient

def mdioBusAttributes( invMdioDev ):
   upstreamBus = invMdioDev.upstreamBus
   assert len( upstreamBus.mdioMasters ) == 1
   accelBlock = next( iter( upstreamBus.mdioMasters.values() ) )
   busId = upstreamBus.mdioBusId[ accelBlock ]
   assert accelBlock.tacType.fullTypeName == "Inventory::Mdio::AccelBlock"
   arbusAccelId = accelBlock.id
   agentId = accelBlock.hwMdioAgent.agentId
   return ( busId, arbusAccelId, agentId )

def ahamDescFromMdioBus( busId, arbusAccelId, portAddr, agentId ):
   ad = MdioClient.ahamDesc( arbusAccelId=arbusAccelId,
                             busId=busId,
                             portAddr=portAddr,
                             agentId=agentId )
   return ad

