#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Bool, Int
from CliModel import Dict, Enum, DeferredModel
from ArnetModel import IpGenericAddress
from IntfModels import Interface

class DfInfo( DeferredModel ):
   dfState = Enum( help="Current DF election state",
                   values=( 'offer', 'lose', 'win', 'backoff' ) )
   df = Bool( help="If true, the router is the DF for the specified interface",
                optional=True )
   dfAddr = IpGenericAddress( help="DF IP address", optional=True )
   routeMetric = Int( help="DF route metric", optional=True )
   routePreference =  Int( help="DF route preference", optional=True )
   intf = Interface( help="Blah Interface", optional=True )

class Rpas( DeferredModel ):
   dfInfo = Dict( help="Mapping from RP address to DF information",
                  keyType=IpGenericAddress, valueType=DfInfo )

class Intfs( DeferredModel ):
   rpaDfInfo = Dict( help="Mapping from interface to DF information",
                     keyType=Interface, valueType=Rpas )
