#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Logging

SYS_SWI_UNSUPPORTED = Logging.LogHandle(
              "SYS_SWI_UNSUPPORTED",
              severity=Logging.logEmergency,
              fmt="The boot image does not support the system (%s)",
              explanation="Architecture of booted image is unsupported"
                          " for current platform",
              recommendedAction="Load an EOS image with the correct "
                                "architecture for this platform" )

SYS_BOOT_INFO_ERROR = Logging.LogHandle(
              "SYS_BOOT_INFO_ERROR",
              severity=Logging.logWarning,
              fmt="System encountered an error in retrieving information but "
                  "will continue to boot (%s)",
              explanation="Error in retrieving system or achitecture info",
              recommendedAction=Logging.NO_ACTION_REQUIRED )
