# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import collections
import email

class Platform:
   '''This is a description of the system we're operating on'''
   smbusDescFields = 'accelId busId offset'
   SmbusDesc = collections.namedtuple( 'SmbusDesc', smbusDescFields )
   name = None

   def matchPlatform( self, platform ):
      raise NotImplementedError

   def powerSupplySlotSmbusDescs( self ):
      raise NotImplementedError

   def scdPciAddr( self ):
      raise NotImplementedError

class PlatformPlugin:
   '''This holds a list of Systems'''
   def __init__( self ):
      self.platforms_ = []

   def registerPlatform( self, platform ):
      self.platforms_.append( platform )

   def platforms( self ):
      return self.platforms_

def getPlatform():
   with open( "/etc/prefdl" ) as f:
      prefdl = f.read()
   prefdlParams = email.message_from_string( prefdl )
   platformName = prefdlParams.get( 'SID', '' )
   platformPlugin = PlatformPlugin()
   Plugins.loadPlugins( 'PlatformPlugin', context=platformPlugin )
   for platform in platformPlugin.platforms():
      if platform.matchPlatform( platformName ):
         return platform
   return None
