# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SharedMem
import Tac
import AncillaryCoreMemory

def newMounter( mounterType, em, agentDirName, mounterName, sliceId=None ):
   shmemEm = SharedMem.entityManager( em.sysname(), True )
   dmamemEm = AncillaryCoreMemory.entityManager( em.sysname() )
   if sliceId is None:
      sliceId = ''
   sysnameDir = Tac.root.newEntity( 'Tac::Dir', em.sysname() )
   agentDir = sysnameDir.newEntity( 'Tac::Dir', agentDirName )
   if agentDir.entity.get( mounterName ):
      agentDir.deleteEntity( mounterName )

   # Load profile files for this agent, if any so new mount APIs work.
   em.cEntityManager().mountFileInfoWrap.addAgent( agentDirName,
                                                   "" )
   mounter = agentDir.newEntity( mounterType, mounterName )
   mounter.loader = ( agentDirName,
                      mounterName,
                      em.cEntityManager(),
                      shmemEm,
                      dmamemEm,
                      sliceId )
   return mounter
