#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Logging

POE_POWER_MAINTAIN_RPR_INCOMPATIBLE = Logging.LogHandle(
   "POE_POWER_MAINTAIN_RPR_INCOMPATIBLE",
   severity=Logging.logWarning,
   fmt="PoE reboot action maintain is incompatible with redundancy protocol RPR. "
   "PoE ports will stop providing power during switchover.",
   explanation="When the redundancy protocol is RPR, the PoE reboot action will be "
   "power-off.",
   recommendedAction="Either disable reboot action maintain or use SSO or simplex "
   "redundancy modes." )
