# Copyright (c) 2009-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell, Tac
import sys, os

def OptionParser():
   import optparse # pylint: disable=deprecated-module,import-outside-toplevel
   parser = optparse.OptionParser()
   defaultSysname = os.environ.get( 'SYSNAME', 'ar' )
   parser.add_option( "-s", "--sysname", action="store",
                   help="System name (default: %default)",
                   default=defaultSysname )
   return parser

def exitWithError( reason ):
   print( reason )
   sys.exit( 1 )

def hwPowerSupplySlotConfig( sysdbRoot ):
   powerSupplySlotConfig = sysdbRoot.entity[ "hardware/powerSupply/slot/config" ]
   return powerSupplySlotConfig

def hwPowerSupplyCellConfig( sysdbRoot ):
   powerSupplyCellConfig = sysdbRoot.entity[
      # pylint: disable-next=consider-using-f-string
      "hardware/powerSupply/config/cell/%d" % Cell.cellId() ]
   return powerSupplyCellConfig

def envPowerStatusDir( sysdbRoot ):
   return sysdbRoot.entity[ "environment/archer/power/status/powerSupply" ]

def configsAndStatuses( sysdbRoot ):
   tempStatus = sysdbRoot.entity[ "environment/archer/temperature/status/system" ]
   tConfig = sysdbRoot.entity[ "environment/thermostat/config" ]
   tStatus = sysdbRoot.entity[ "environment/thermostat/status" ]
   return ( tempStatus, tConfig, tStatus )
