# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, os

class ReadOnly:
   def __init__( self, obj ):
      self.__dict__[ '_obj' ] = obj

   def __getattr__( self, attr ):
      return getattr( self._obj, attr )

   def __setattr__( self, attr, *args ):
      raise AttributeError( attr )

   __delattr__ = __setattr__

def productAttributes():
   attributes = Tac.singleton( "ProductAttribute::ProductAttributes" )
   return ReadOnly( attributes )

def attributesForProduct( product ):
   oldProductEnv = None
   if 'PRODUCT' in os.environ:
      oldProductEnv = os.environ[ 'PRODUCT' ]
   os.environ[ 'PRODUCT' ] = product
   ret = Tac.newInstance( "ProductAttribute::ProductAttributes",
         "ProductAttributes" )
   if oldProductEnv is not None:
      os.environ[ 'PRODUCT' ] = oldProductEnv
   else:
      del os.environ[ 'PRODUCT' ]
   return ret

def productGenerator():
   return Tac.newInstance( "ProductAttribute::ProductListGenerator", "prdGen" )
