#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

def PtpModeType():
   return Tac.Type( 'Ptp::PtpMode' )

def PtpProfileType():
   return Tac.Type( 'Ptp::PtpProfile' )

def PtpConstants():
   return Tac.Type( "Ptp::Constants" )

def PtpLogMgr():
   return Tac.singleton( 'Tac::LogManager' )

MpassStatus = Tac.Type( "Ptp::Mpass::Status" )
MessageTypeNumber = Tac.Type( "Ptp::MessageTypeNumber" )

lagTxMessageStr = { MessageTypeNumber.messageAnnounce : "announce",
                    MessageTypeNumber.messageSync : "sync",
                    MessageTypeNumber.messageFollowUp : "follow-up",
                    MessageTypeNumber.messageDelayReq : "delay-req",
                    MessageTypeNumber.messageDelayResp : "delay-resp" }

TimestampHdrSize = Tac.Type( "Ptp::TimestampHeaderWrapper" ).headerSize()
