# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from Arnet import PktParserTestLib
from PtpConstants import PtpHdrSize, PTP_EVENT_PORT, PTP_GENERAL_PORT
import Tac, Tracing

t6 = Tracing.trace6

def ptpHdr( data ):
   """
   Returns ( offset of ptpHdr, parsed ptpHdr )
   """
   # This should be a bit more strict. It doesn't check DMAC or DIP.
   p, headers, offset = PktParserTestLib.parsePktStr( data )
   ptp = False
   udpHdr = PktParserTestLib.findHeader( headers, "UdpHdr" )
   if udpHdr:
      t6( "UDP Packet, dest port =", udpHdr.dstPort )
      if udpHdr.dstPort == PTP_EVENT_PORT or udpHdr.dstPort == PTP_GENERAL_PORT:
         ptp = True
   else:
      ethHdr = PktParserTestLib.findHeader( headers, "EthHdr" )
      if ethHdr:
         t6( "Non-UDP packet, EtherType =", ethHdr.ethType )
         if ethHdr.ethType == "ethTypeDot1Q":
            ethHdr = PktParserTestLib.findHeader( headers, "EthDot1QHdr" )
            if not ethHdr:
               return ( None, None )
            t6( "Vlan tagged packet, EtherType =", ethHdr.ethType )

         if ethHdr.ethType == "ethTypePtp":
            ptp = True
      else:
         t6( "Couldnt find EthHdr?" )
   if ptp:
      if p.bytes - offset < PtpHdrSize:
         t6( "Packet is", p.bytes, "smaller than minimum of",
             ( offset + PtpHdrSize ) )
         return ( None, None )
      ptpHeader = Tac.newInstance( "Ptp::CommonMessageWrapper", p, offset )
      return ( offset, ptpHeader )
   return ( None, None )

def ptpHdrOffset( data ):
   offset, _ = ptpHdr( data )
   if offset is not None:
      return offset
   return None

def ptpPacketType( data ):
   _, header = ptpHdr( data )
   if header is not None:
      return header.messageType
   return None

def ptpTwoStepFlag( data ):
   _, header = ptpHdr( data )
   if header is not None:
      flags = header.flagField
      return ( flags & 0x2 ) >> 1 == 1
   return None
