# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing

t0 = Tracing.Handle( "OpenConfigQosCommonLib" ).trace0

def getInterfaceIdAfterValidation( interfaces, interfaceId ):
   interface = interfaces.interface.get( interfaceId )
   assert interface
   interfaceName = interface.interfaceRef.config.interface
   subInterface = interface.interfaceRef.config.subinterface
   if subInterface:
      interfaceName = f"{interfaceName}.{subInterface}"
   if interfaceName:
      # validate interface-id is same as interface from interfaceRef
      # TODO: remove this once the interface-ref is fully supported and
      # interface-id could be any custom string in that case
      assert interfaceId == interfaceName
   return interfaceId
