# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from RcfAstInterface import (
   Function,
   Call,
)

class FunctionScopeAstInterfaceGenPhase:
   """ class that constructs the ast interfaces
   """
   def visitCall( self, call ):
      return Call( funcName=call.funcName )

   def visitFunction( self, function ):
      functionSelf = function.symbol.functionSelf
      funcParamTypes = tuple( function.symbol.funcParamTypes )

      if function.valid:
         functionCalls = tuple( self.visitCall( call )
                                for call in function.functionCalls )
      else:
         functionCalls = tuple()

      return Function( name=function.name,
                       valid=function.valid,
                       functionSelf=functionSelf,
                       funcParamTypes=funcParamTypes,
                       functionCalls=functionCalls )

def generateAstInterfaces( functions ):
   astInterfaceGen = FunctionScopeAstInterfaceGenPhase()
   for function in functions:
      yield astInterfaceGen.visitFunction( function )
