#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import RcfAst

class Listener:
   """ Rcf Listener interface to listen to the Abstract Syntax Tree (AST).
   """
   def __init__( self ):
      self.dispatchMap = {
         RcfAst.Root: self.listenRoot,
         RcfAst.Function: self.listenFunction,
         RcfAst.Block: self.listenBlock,
         RcfAst.IfStmt: self.listenIfStmt,
         RcfAst.Call: self.listenCall,
         RcfAst.ExternalRefOp: self.listenExternalRefOp,
         RcfAst.ExternalRef: self.listenExternalRef,
         RcfAst.Assign: self.listenAssign,
         RcfAst.Return: self.listenReturn,
         RcfAst.Exit: self.listenExit,
         RcfAst.CommunityValue: self.listenCommunityValue,
         RcfAst.Constant: self.listenConstant,
         RcfAst.Range: self.listenRange,
         RcfAst.Collection: self.listenCollection,
         RcfAst.Attribute: self.listenAttribute,
         RcfAst.BinOp: self.listenBinOp,
         RcfAst.LogicalOp: self.listenLogicalOp,
         RcfAst.Not: self.listenNot,
         RcfAst.Directive: self.listenDirective,
      }

   def listen( self, node, action, **kwargs ):
      self.dispatchMap[ type( node ) ]( node, action, **kwargs )

   def listenRoot( self, root, action, **kwargs ):
      pass

   def listenFunction( self, function, action, **kwargs ):
      pass

   def listenBlock( self, block, action, **kwargs ):
      pass

   def listenIfStmt( self, ifStmt, action, **kwargs ):
      pass

   def listenSequentialExpr( self, sequentialExpr, action, **kwargs ):
      pass

   def listenCall( self, call, action, **kwargs ):
      pass

   def listenExternalRefOp( self, externalRefOp, action, **kwargs ):
      pass

   def listenExternalRef( self, extRef, action, **kwargs ):
      pass

   def listenAssign( self, assign, action, **kwargs ):
      pass

   def listenReturn( self, returnOperation, action, **kwargs ):
      pass

   def listenExit( self, exitOperation, action, **kwargs ):
      pass

   def listenCommunityValue( self, commValue, action, **kwargs ):
      pass

   def listenConstant( self, constant, action, **kwargs ):
      pass

   def listenRange( self, rangeNode, action, **kwargs ):
      pass

   def listenCollection( self, collection, action, **kwargs ):
      pass

   def listenAttribute( self, attribute, action, **kwargs ):
      pass

   def listenBinOp( self, binOp, action, **kwargs ):
      pass

   def listenLogicalOp( self, logicalOp, action, **kwargs ):
      pass

   def listenNot( self, notExpr, action, **kwargs ):
      pass

   def listenDirective( self, directive, action, **kwargs ):
      pass
