# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from dataclasses import dataclass, field
from FrozenDict import frozendict
from typing import Optional

@dataclass( frozen=True )
class Type:
   """ Simple Rcf Type for Simple attributes.

   Attributes:
      displayName (str): user-facing name to be rendered in compilation errors
      variableAetTypename (str): AET type to be used for variables of this RCF type
      aetOpTypes (dict): dict of AET type indexed by operation.
   """
   name: str
   displayName: str
   aetOpTypes: frozendict = field( default_factory=frozendict )
   variableAetTypename: Optional[ str ] = None

@dataclass( frozen=True )
class CollectionType( Type ):
   """ Rcf Type for collections.
   See the Collection section in the RcfMetadata.yaml for the Collection types

   Attributes:
      contentType (list): the valid types of items contained in the collection.
   """
   contentTypes: frozenset = frozenset()

@dataclass( frozen=True )
class Enum( Type ):
   """ An Rcf Type used to represent Enums like Origin.

   Attributes:
      valueDict (dict): dict of enum name to enum value.
   """
   valueDict: frozendict = field( default_factory=frozendict )
