# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from collections import namedtuple
import RcfTypeFuture as Rcf

# Helper type containing the aclListConfig, roaTableStatusDir and
# dynPfxListConfigDir  which are used to validate the existence of
# external references during the symbol table generation phase.
# This bundling is only to pass fewer arguments in python so there
# is no need for this to be a tac type.
RcfExternalConfig = namedtuple( "RcfExternalConfig",
                                [ "aclListConfig",
                                  "roaTableStatusDir",
                                  "dynPfxListConfigDir",
                                  "tunnelRibNameIdMap" ] )

# rib_tunnel can also include user-defined ribs, so validate rib_tunnel against
# self.tunnelRibNameIdMap which includes both built-in and custom rib_tunnels.
def tunnelRib( name ):
   rib = Rcf.Routing.Rib.ResolutionRibConfig(
      Rcf.Routing.Rib.ResolutionRibSource.tunnelRib )
   rib.tunnelRibName = name
   return rib

BuiltinRibs = {
   'rib_ip': {
      'system-connected':
         Rcf.Routing.Rib.ResolutionRibConfig(
            Rcf.Routing.Rib.ResolutionRibSource.systemConnected ),
      'system-unicast-rib':
         Rcf.Routing.Rib.ResolutionRibConfig(
            Rcf.Routing.Rib.ResolutionRibSource.systemUnicastRib ) },
   'rib_colored_tunnel': {
      'system-colored-tunnel-rib': tunnelRib( 'system-colored-tunnel-rib' )
   },
   'rib_tunnel': {
      'system-tunnel-rib': tunnelRib( 'system-tunnel-rib' )
   }
}

ResolutionRibTypes = BuiltinRibs.keys()
