# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import antlr4

from RcfLexer import (
   InputStream,
   RcfLexer,
)
from RcfParser import RcfParser

def runRcfLexer( diag, codeUnitText ):
   lexer = RcfLexer( InputStream( codeUnitText ) )
   lexer.removeErrorListeners()
   lexer.addErrorListener( diag )
   return lexer, antlr4.CommonTokenStream( lexer )

def runRcfParser( diag, tokenStream, rule='rcf' ):
   parser = RcfParser( tokenStream )
   # Set to report all ambiguities and errors
   # pylint: disable=protected-access
   parser._interp.predictionMode = antlr4.PredictionMode.LL_EXACT_AMBIG_DETECTION

   parser.removeErrorListeners()
   parser.addErrorListener( diag )
   return getattr( parser, rule )()
