# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Bogus import to generate explicit dependency on Arnet
# pkgdeps: import Arnet

from RcfInstantiatingCollHelpers import InstantiatingCollectionGV
from TypeFuture import TacLazyType

AllFunctionStatus = TacLazyType( "Rcf::AllFunctionStatus" )
Config = TacLazyType( "Rcf::Config" )
Status = TacLazyType( "Rcf::Status" )

aetNodeInstantiator = InstantiatingCollectionGV.instantiator( 'allAetEntities' )

class Eval:
   """ Lazy load the Tacc type we use in the AET.
   """
   AetNodeBase = TacLazyType( "Rcf::Eval::AetNodeBase" )
   MetadataType = TacLazyType( "Rcf::Eval::FunctionMetadata" )
   ExpressionListType = TacLazyType( "Rcf::Eval::ExpressionList" )
   BlockType = TacLazyType( "Rcf::Eval::Block" )
   FunctionType = TacLazyType( "Rcf::Eval::Function" )
   FunctionCallExpressionType = TacLazyType( "Rcf::Eval::FunctionCallExpression" )
   FunctionArgumentListType = TacLazyType(
      "Rcf::Eval::FunctionArgumentList" )
   IfExpressionType = TacLazyType( "Rcf::Eval::IfExpression" )
   NotExpressionType = TacLazyType( "Rcf::Eval::NotExpression" )
   AndOperatorType = TacLazyType( "Rcf::Eval::AndOperator" )
   OrOperatorType = TacLazyType( "Rcf::Eval::OrOperator" )
   SequentialOperatorType = TacLazyType( "Rcf::Eval::SequentialOperator" )
   LogicalOperatorListType = TacLazyType( "Rcf::Eval::LogicalOperatorList" )
   LogicalOperatorExpressionType = TacLazyType(
      "Rcf::Eval::LogicalOperatorExpression" )
   ReturnExpressionType = TacLazyType( "Rcf::Eval::ReturnExpression" )
   ExitExpressionType = TacLazyType( "Rcf::Eval::ExitExpression" )
   AttributeSet = TacLazyType( "Rcf::Eval::AttributeSet" )
   ModifiableAttributeSet = TacLazyType( "Rcf::Eval::ModifiableAttributeSet" )
   AccessibleAttributes = TacLazyType( "Rcf::Eval::AccessibleAttributes" )

   """Wrappers for instantiating the AET nodes.
   Pass the typename instead of the type self (from above), since
   aetNodeInstantiator needs only the name and it is not possible to get
   the name from the TacLazyType (it is a protected member).
   """
   ExpressionList = aetNodeInstantiator( "Rcf::Eval::ExpressionList" )
   Block = aetNodeInstantiator( "Rcf::Eval::Block" )
   Function = aetNodeInstantiator( "Rcf::Eval::Function" )
   FunctionCallExpression = aetNodeInstantiator(
      "Rcf::Eval::FunctionCallExpression" )
   FunctionArgumentList = aetNodeInstantiator( "Rcf::Eval::FunctionArgumentList" )
   IfExpression = aetNodeInstantiator( "Rcf::Eval::IfExpression" )
   NotExpression = aetNodeInstantiator( "Rcf::Eval::NotExpression" )
   AndOperator = aetNodeInstantiator( "Rcf::Eval::AndOperator" )
   OrOperator = aetNodeInstantiator( "Rcf::Eval::OrOperator" )
   SequentialOperator = aetNodeInstantiator( "Rcf::Eval::SequentialOperator" )
   LogicalOperatorList = aetNodeInstantiator( "Rcf::Eval::LogicalOperatorList" )
   LogicalOperatorExpression = aetNodeInstantiator(
      "Rcf::Eval::LogicalOperatorExpression" )
   ReturnExpression = aetNodeInstantiator( "Rcf::Eval::ReturnExpression" )
   ExitExpression = aetNodeInstantiator( "Rcf::Eval::ExitExpression" )

   # Special community values that are used within the compiler:
   CommunityValues = TacLazyType( "Rcf::Eval::CommunityValues" )

   # More AET nodes will be added here automatically by RcfMetadata.py

   # This is to get rid of pylint errors about using non-existant attributes.
   def __getattr__( self, key ):
      # This should never get called, since we always only access attributes that
      # have been explicitly created using setattr.
      assert False, '__getattr__ should never get invoked'

   class Bgp:
      # More AET nodes will be added here automatically by RcfMetadata.py

      # This is to get rid of pylint errors about using non-existant attributes.
      def __getattr__( self, key ):
         # This should never get called, since we always only access attributes that
         # have been explicitly created using setattr.
         assert False, '__getattr__ should never get invoked'

class Arnet:
   EthAddr = TacLazyType( "Arnet::EthAddr" )
   IpAddr = TacLazyType( "Arnet::IpAddr" )
   IpGenAddr = TacLazyType( "Arnet::IpGenAddr" )
   IpGenPrefix = TacLazyType( "Arnet::IpGenPrefix" )
   IntfId = TacLazyType( "Arnet::IntfId" )
   AddressFamily = TacLazyType( "Arnet::AddressFamily" )

class Acl:
   CommunityValue = TacLazyType( "Acl::CommunityValue", returnValueConst=True )

symbolInstantiator = InstantiatingCollectionGV.instantiator(
   'allDebugSymbolEntities' )

class Debug:
   SymbolBase = TacLazyType( "Rcf::Debug::SymbolBase" )
   SymbolContainerType = TacLazyType( "Rcf::Debug::SymbolContainer" )
   SymbolLocationType = TacLazyType( "Rcf::Debug::SymbolLocation" )
   AetNodeSymbolType = TacLazyType( "Rcf::Debug::AetNodeSymbol" )
   InternalAetNodeSymbolType = TacLazyType( "Rcf::Debug::InternalAetNodeSymbol" )
   FunctionDefinitionType = TacLazyType( "Rcf::Debug::FunctionDefinition" )
   FunctionSymbolType = TacLazyType( "Rcf::Debug::FunctionSymbol" )
   ParensDataType = TacLazyType( 'Rcf::Debug::ParensData' )
   StatementExpressionDataType = TacLazyType( 'Rcf::Debug::StatementExpressionData' )
   FunctionCallDataType = TacLazyType( "Rcf::Debug::FunctionCallData" )
   BlockDataType = TacLazyType( "Rcf::Debug::BlockData" )
   IfDataType = TacLazyType( 'Rcf::Debug::IfData' )

   SymbolContainer = symbolInstantiator( 'Rcf::Debug::SymbolContainer' )
   SymbolLocation = symbolInstantiator( 'Rcf::Debug::SymbolLocation' )
   AetNodeSymbol = symbolInstantiator( 'Rcf::Debug::AetNodeSymbol' )
   InternalAetNodeSymbol = symbolInstantiator( 'Rcf::Debug::InternalAetNodeSymbol' )
   FunctionDefinition = symbolInstantiator( 'Rcf::Debug::FunctionDefinition' )
   FunctionSymbol = symbolInstantiator( 'Rcf::Debug::FunctionSymbol' )
   ParensData = symbolInstantiator( 'Rcf::Debug::ParensData' )
   StatementExpressionData = symbolInstantiator(
      'Rcf::Debug::StatementExpressionData' )
   FunctionCallData = symbolInstantiator( 'Rcf::Debug::FunctionCallData' )
   BlockData = symbolInstantiator( 'Rcf::Debug::BlockData' )
   IfData = symbolInstantiator( 'Rcf::Debug::IfData' )

   Symbols = TacLazyType( "Rcf::Debug::Symbols" )

class ConfigTag:
   ConfigTagStatus = TacLazyType( "ConfigTag::ConfigTagStatus" )
   ConfigTagIdState = TacLazyType( "ConfigTag::ConfigTagIdState" )

class Metadata:
   FunctionDomain = TacLazyType( "Rcf::Metadata::FunctionDomain" )

class Poa:
   RcfPoaConfig = TacLazyType( "Rcf::Poa::RcfPoaConfig" )

class Routing:
   class Rib:
      ResolutionRibConfig = TacLazyType( "Routing::Rib::ResolutionRibConfig" )
      ResolutionRibProfileConfig = \
         TacLazyType( "Routing::Rib::ResolutionRibProfileConfig" )
      ResolutionRibSource = TacLazyType( "Routing::Rib::ResolutionRibSource" )

class Evpn:
   Esi = TacLazyType( "Evpn::Esid" )

# Will be populated further by RcfMetadata.py
OperatorTypeToSyntax = {
   Eval.AndOperatorType.tacType: 'and',
   Eval.OrOperatorType.tacType: 'or',
   Eval.SequentialOperatorType.tacType: '??',
}
AttributeTypeToSyntax = {}
BuiltinFnExprToData = {}
