# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import Logging

resetCauses = [
   'cpuCatErrFault',
   'cpuFault',
   'cpuSlpS3Fault',
   'cpuSlpS5Fault',
   'cpuThermTripFault',
   'dpmSeuError',
   'fansMissing',
   'fastReboot',
   'fatalError',
   'hitlessReload',
   'internalRail',
   'kernel',
   'overTemp',
   'pluto',
   'plxError',
   'powerLoss',
   'procError',
   'cpuMachineCheck',
   'cpuSyncFlood',
   'psuFault',
   'scdSeuError',
   'cpldSeuError',
   'thermo',
   'unknown',
   'userReload',
   'watchdog',
   'switchChipPowerLoss',
   'portModulePowerLoss',
   'switchChipPciError',
   'cardUnseated',
   'killSwitchFault', 
   'appFpgaSeuError',
   'recoveryPolicyReload',
   'recoveryPolicyShutdown',
]

# XXX_APECH This constant should live elsewhere and be shared with Thermostat.py...
flashDir = os.path.join( os.environ.get( "FILESYSTEM_ROOT", "/mnt" ),
                         "flash" )
debugDir = os.path.join( flashDir, "debug" )

reloadDebugFile = os.path.join( debugDir, "local_reload_cause" )

kernelPanicFile = os.path.join( debugDir, 'kernelcrash' )
consumeFileStr = 'rebootIsImminent'
wDescription = 'The system rebooted due to a watchdog'
wkDescription = 'The system rebooted due to a watchdog caused by a kernel panic'
wuDescription = 'User-initiated reload interrupted by watchdog'
wBiosDescription = 'The system rebooted due to a BIOS watchdog'
kDescription = 'The system rebooted due to a kernel panic'
kRecommendedAction = 'This may indicate a software or hardware problem.' \
                     '\nContact your customer support representative and provide ' \
                     'the contents\nof the "Debugging Information" below.'
wRecommendedAction = 'This may indicate a software or hardware problem.' \
                     '\nContact your customer support representative.'
noRecommendedAction = 'No action necessary.'
powerLossDescription = 'The system rebooted due to a Power Loss'
ztpDescription = 'System reloaded due to Zero Touch Provisioning'
reloadDescription = 'Reload requested by the user.'
reloadTimeDescription = 'Reload occurred at'
manualSwitchoverDescription = 'Manual switchover requested by the user.'
switchoverDescription = 'Supervisor switchover.'
overTempPowercycleDescription = "Software power-cycled system due to critical " \
                                "system temperature"
overTempDescription = 'Software shut down system due to critical system temperature'
cardOverTempDescription = 'Software shut down system due to card temperature ' \
                          'critical'
thermoInsufficientFansDescription = 'Software shut down system due to' \
                                    ' insufficient fans'
fansMissingDescription = "The system rebooted as fans were not detected"
psuFaultDescription = "The system rebooted due to a PSU fault not caused by mains " \
                      "failure"
cpuSlpS3FaultDescription = "The system rebooted due to a CPU S3 sleep state fault"
cpuSlpS5FaultDescription = "The system rebooted due to a CPU S5 sleep state fault"
cpuThermTripFaultDescription = "The system rebooted due to a CPU thermal fault"
cpuCatErrFaultDescription = "The system rebooted due to a CPU CATERR fault"
cpuFaultDescription = "The system rebooted due to an unexpected fault on the CPU " \
                      "card."
fatalErrorDescription = "Fatal error occurred."
hitlessReloadDescription = "Hitless reload requested by the user."
fatalErrHitlessDescription = "User-requested hitless reload interrupted by a fatal "\
                             "error"
failSafeRebootDescription = "Fail safe reboot occurred."
failSafeHitlessDescription = "User-requested hitless reload followed by a fail " \
                             "safe reboot occurred."
plxErrorDescription = "The system rebooted due to a PLX fatal error"
scdSeuErrorDescription = "The system rebooted due to an SEU error on the Scd"
dpmSeuErrorDescription = "The system rebooted due to an SEU error on the Dpm"
procErrorDescription = "The system rebooted due to a processor fatal error"
cpuMachineCheckDescription = "The system rebooted due to a CPU machine check "\
                             "exception."
cpuSyncFloodDescription = "The system may have rebooted due to a CPU internal "\
                           "error (code: syncflood)."
cpldSeuErrorDescription = "The system rebooted due to an SEU error on the Cpld"
switchChipPowerLossDescription = "The system rebooted due to power loss on the " \
                                 "switching chip."
switchChipPciErrorDescription = "The system rebooted due to a PCI error in the " \
                                "switching ASIC."
portModulePowerLossDescription = "The system rebooted due to a power event in " \
                                 "a port module."
cardUnseatedDescription = "The system rebooted due to a card being unseated"
internalRailFailure = "The system rebooted due to an internal rail failure"
internalRailRecommendedAction = \
    'Software detected that the switch rebooted due to an internal rail failure.' \
    f'\n{Logging.CALL_SUPPORT_IF_PERSISTS}'
softwareReloadDescription = "Reload requested by software"
fpgaUpgradeReloadDescription = "Reload requested after FPGA upgrade"
unknownError = "The system rebooted due to unknown reasons."
buttonReloadDescription = "Reload requested by the user using the Mode button"
resetButtonReloadDescription = "Reload requested by the user using the reset button"
buttonKeyPadReloadDescription = "Reload requested by the user using the button" \
                                "keypad(s)"
rollbackDescription = "The system rebooted because a rollback recovery was"\
                      " requested by the user."
factoryResetDescription = "The system rebooted because a factory reset was" \
                          " requested by the user."
appFpgaSeuErrorDescription = "The system rebooted due to an SEU error on one of " \
                             "the Application FPGAs"
recoveryPolicyReloadDescription = \
   "The system rebooted in an attempt to recover from repeat failures"
recoveryPolicyShutdownDescription = \
   "The system shutdown to prevent losing traffic due to repeat faliures"

overTempRecommendedAction = "Software detected that the switch started" \
   " overheating and "\
   "hence turned off POS12V causing the switch to restart. " \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

thermoRecommendedAction = "If the system was shut down due to " \
   "insufficient or mismatched fans:" \
   "   * check you have properly installed fans with the same airflow direction." \
   "   * check that all fans are tightly screwed into place." \
   "   * replace all failed fans" \
   "If the system was shut down due to overtemperature:" \
   "   * check that all air vents are unobstructed." \
   "   * check that the switch is operating within its designed range of" \
   f"0-40C ambient temperature.{Logging.CALL_SUPPORT_IF_PERSISTS}"

scdSeuErrorRecommendedAction = \
   "Software detected that the switch rebooted due to an SEU error on the Scd." \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

switchChipPowerLossRecommendedAction = \
   "Software detected a power event in a power supply that supplies the " \
   f"switching chip.\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

switchChipPciErrorRecommendedAction = \
   "Software detected a PCI error in the switching ASIC." \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

portModulePowerLossRecommendedAction = \
   "Software detected a power event in a power supply that supplies the " \
   f"port modules.\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

plxErrorRecommendedAction = \
   "The system rebooted due to a PLX fatal error." \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

procErrorRecommendedAction = \
   "The system rebooted due to a processor fatal error." \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

cpuMachineCheckRecommendedAction = \
   "The CPU detected an internal error condition and reset the system." \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

cpuSyncFloodRecommendedAction = \
   "The system rebooted due to a CPU internal error (code: syncflood). " \
   f"This can occur during a forced reboot.\n{Logging.CALL_SUPPORT_IF_PERSISTS}" \

fatalErrorRecommendedAction = \
   "The system rebooted due to a fatal error." \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

psuFaultRecommendedAction = \
   "The system rebooted due to a PSU fault not caused by mains failure." \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

cpuSlpS3FaultRecommendedAction = \
   "The system rebooted due to a CPU S3 sleep state fault." \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

cpuSlpS5FaultRecommendedAction = \
   "The system rebooted due to a CPU S5 sleep state fault." \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

cpuThermTripFaultRecommendedAction = \
   "The system rebooted due to a CPU thermal fault." \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

cpuCatErrFaultRecommendedAction = \
   "The system rebooted due to a CPU CATERR error." \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

cpuFaultRecommendedAction = cpuFaultDescription + \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

cardUnseatedRecommendedAction = \
   "Check the card is firmly seated and the ejector handle is closed." \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

killSwitchFaultDescription = "The system rebooted due to a kill switch fault"

killSwitchFaultRecommendedAction = killSwitchFaultDescription + \
   f"\n {Logging.CALL_SUPPORT_IF_PERSISTS}"

scdHeartbeatIdleDescription = \
   "The system rebooted due to the heartbeat from the SCD to the CPLD going idle"

scdHeartbeatIdleRecommendedAction = scdHeartbeatIdleDescription + \
   f"\n {Logging.CALL_SUPPORT_IF_PERSISTS}"

appFpgaSeuErrorRecommendedAction = \
   "Software detected that the switch rebooted due to an SEU error on one of the " \
   "Application FPGAs." \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

recoveryPolicyReloadRecommendedAction = recoveryPolicyReloadDescription + \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

recoveryPolicyShutdownRecommendedAction = recoveryPolicyShutdownDescription + \
   f"\n{Logging.CALL_SUPPORT_IF_PERSISTS}"

# BUG749500:To be updated along with adding logic for combined supervisor switchover
doubleSwitchoverDescription = "Supervisor switchover during switchover"
