# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import Tac
from TypeFuture import TacLazyType

# maintain a copy of values for use in our python tests.
WEIGHTED_FAIR_SCALE = 1024
RX_DP_WEIGHT = 512
RX_DP_SMALL_WEIGHT = 128
TX_DP_WEIGHT = 512
RX_CP_WEIGHT = 128
CPU_RECEIVE_WEIGHT = 128
RX_DP_OFFLOADQ_WEIGHT = 256
INVALID_WEIGHT = -1
CPU_RECEIVE_TC_NAME = "cpu_receive"

FlowCacheWalkerThreadConst = TacLazyType( "Sfe::FlowCacheWalkerThreads" )

def flowCacheWalkerThreadsDefault( platformRuby, nCpCores ):
   # based on the number of control plane cores decide if additional walker
   # threads should be chosen.
   useAdditionalThreads = bool( nCpCores >= 2 )
   if os.getenv( "VEOS_SIM_IS_RUBY" ):
      # DFWSFE namespace dut
      return Tac.Value( "Sfe::FlowCacheWalkerThreads",
                        FlowCacheWalkerThreadConst.platformDfwNsDutDefault )
   elif platformRuby:
      return Tac.Value( "Sfe::FlowCacheWalkerThreads",
                        FlowCacheWalkerThreadConst.platformRubyDefault )
   elif useAdditionalThreads:
      return Tac.Value( "Sfe::FlowCacheWalkerThreads",
                        FlowCacheWalkerThreadConst.platformLargeDefault )
   else:
      return Tac.Value( "Sfe::FlowCacheWalkerThreads",
                        FlowCacheWalkerThreadConst.platformSmallDefault )
