# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from TypeFuture import TacLazyType

IntfDetails = TacLazyType( 'IntfSnmp::IntfDetails' )
# pkgdeps: rpm Arnet-lib
IpGenAddr = TacLazyType( 'Arnet::IpGenAddr' )
IntfId = TacLazyType( 'Arnet::IntfId' )

def ifindexToIntf( ifIndexMap, ifindex ):
   return Tac.Value( 'Arnet::IntfId', ifIndexMap.get( ifindex, '' ) )

def valueOrUnknown( value ):
   # pylint: disable-next=isinstance-second-argument-not-valid-type
   if isinstance( value, IpGenAddr ):
      return "unknown" if value.isAddrZero else value.stringValue
   # pylint: disable-next=isinstance-second-argument-not-valid-type
   elif isinstance( value, IntfId ):
      return value.stringValue if value else "unknown"
   else:
      return value if value else "unknown"

def vniOrUnknown( value ):
   vniInvalid = 4294967295
   if value == vniInvalid:
      return "unknown"
   else:
      return str( value )

def labelStackString( labelStack, truncated ):
   labels = [ str( l ) for l in labelStack ]
   labels += [ '...' ] if truncated else []
   return '[' + ' '.join( labels ) + ']'
