# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliModel

class _Mode( CliModel.DeferredModel ):
   pass

class Mode( _Mode ):
   header = CliModel.List( valueType=str,
                  help='Header messages. Present only on the Global config mode.',
                  optional=True )
   comments = CliModel.List( valueType=str, help='Mode comments', optional=True )
   cmds = CliModel.Dict( keyType=str, valueType=_Mode,
                help='Dictionary of config commands in this mode.  The key is '
                     'a config command.  The config command might be:\n'
                     '- a simple command and in this case the value is NULL. '
                     ' Example: \'cmds\': { \'no ip routing\' : NULL } \n'
                       '- a command leading to a sub-mode and in this case the '
                       'value is a new Mode consisting of potential new config '
                       'commands.  Example: '
                       '\'cmds\': { \'interface Ethernet2\' : { '
                       '                                  \'cmds\': { } }',
                      valueOptional=True )
