# Copyright (c) 2005-2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import EapiClientLib

# For now, some stuff hardcoded, like privilege and sysname

def run( cmdsStr ):
   # pylint: disable-next=unnecessary-comprehension
   cmds = [ c for c in cmdsStr.split( "\n" ) ]
   eapiClient = EapiClientLib.EapiClient( sysname="ar",
                                          disableAaa=True, privLevel=15 )
   try:
      response = eapiClient.runCmds( version="latest", format="json", cmds=cmds )
      result = response[ "result" ]
      resultStr = "OK:\n" + "\n".join( str( r ) for r in result )
   except EapiClientLib.EapiException as e:
      errorData = e.data if e.data else None
      errorDataStr = ""
      if errorData:
         # pylint: disable-next=not-an-iterable
         errorDataStr = "\n".join( str( s ) for s in errorData )
      #errorCode = err.code
      resultStr = "ERROR: " + str( e ) + "\n" + errorDataStr
   except Exception as e:  # pylint: disable-msg=W0703
      resultStr = "ERROR: internal: " + str( e ) + "\n"
   return resultStr
