# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from StorageDevicesFirmware import StorageDevice, readHeader, readBin, fw_path
from StorageDevicesFirmware import StorageFirmwareVersion
import re
import Tac

models = [ "SVM2S46D032GJM23RS", "SV9M2S46D032GJM22", "SV9M2S46D128GJM21",
      "SV9M2S46D128GJM22", "SV9M2S46D128GJM23RS" ]


class SmartModularFirmwareVersion( StorageFirmwareVersion ):
   def __int__( self ):
      m = re.match( r'FW([0-9]+)', self.version )
      if m:
         return int( m.groups()[ 0 ] )
      else:
         raise ValueError

class SmartModular( StorageDevice ):
   def __init__( self, dev, name, fwRev ):
      super( SmartModular, self ).__init__( dev, name, fwRev )
      self.fw_file = ''

   def getLocalVersion( self ):
      fw_info = readHeader( self.name, fw_path )
      return SmartModularFirmwareVersion( fw_info.version )

   def getHwVersion( self ):
      return SmartModularFirmwareVersion( self.fwRev )

   def getUpgradeCommand( self ):
      self.fw_file = readBin( self.name, fw_path )
      upgradeCmd = ( "hdparm --yes-i-know-what-i-am-doing "
      "--please-destroy-my-drive --fwdownload-mode3-max %s %s"
      % ( self.fw_file, self.dev ) )
      return list( upgradeCmd.split( " " ) )

   def postUpgradeReboot( self ):
      return True

def Plugin( context ):
   for model in models:
      context.models[ model ] = SmartModular
